/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class PICpDump {
    public static final String CMD_LINE_BUNDLE = "PIHscCmdLineBundle";
    private static final String FTP_PARAM = "ftp";
    private static final String DVD_PARAM = "dvd";
    private static final String[] FTP_PARAMS = new String[]{"-h", "-u", "--passwd", "-d"};
    private boolean writeToFTP;
    private boolean writeToDVD;
    private String filenames;
    private String hostname;
    private String username;
    private String password;
    private String directory;
    private static final int NUM_VALID_PARMS = 6;
    private HashMap m_validParms = new HashMap(13, 0.5f);

    private PICpDump() {
        this.m_validParms.put("-r", null);
        this.m_validParms.put("-f", null);
        this.m_validParms.put("-h", null);
        this.m_validParms.put("-u", null);
        this.m_validParms.put("--passwd", null);
        this.m_validParms.put("-d", null);
    }

    private void readPassword(PrintStream printStream) throws PIHscClientException {
        try {
            EExecResult eExecResult;
            String string = System.getProperty("HMCtty.name");
            String string2 = null;
            String string3 = null;
            boolean bl = false;
            if (string != null && string != "") {
                eExecResult = EExec.Exec((String)("stty --save --file=" + string));
                string2 = "stty --file=" + string + " " + eExecResult.stdout;
                string3 = "stty --file=" + string + " -echo";
                bl = true;
            }
            Object[] objectArray = new String[]{this.username};
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            printStream.println(HSCResourceBundleUtil.getMessage(CMD_LINE_BUNDLE, "ENTER_OLD_PASSWORD", null, objectArray));
            if (bl) {
                eExecResult = EExec.Exec(string3);
            }
            this.password = bufferedReader.readLine().trim();
            if (bl) {
                eExecResult = EExec.Exec((String)string2);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "ERROR_READING_PASSWORD");
        }
    }

    public int performCommand() throws PIHscClientException, HSCException {
        int n;
        block17: {
            block16: {
                n = 0;
                if (!this.writeToDVD) break block16;
                StringTokenizer stringTokenizer = new StringTokenizer(this.filenames, " ");
                while (stringTokenizer.hasMoreTokens() && n == 0) {
                    String[] stringArray;
                    StringBuffer stringBuffer = new StringBuffer(120);
                    String string = stringTokenizer.nextToken();
                    stringBuffer = new StringBuffer(120);
                    stringBuffer.append("/opt/hsc/bin/copyDumpToDVD ").append(string);
                    try {
                        stringArray = Runtime.getRuntime().exec(stringBuffer.toString());
                        n = stringArray.waitFor();
                    }
                    catch (Throwable throwable) {
                        throw new PIHscClientException("8016", CMD_LINE_BUNDLE, "COMMAND_LINE_ERROR", null, null);
                    }
                    if (n == 2) {
                        stringArray = new String[]{string};
                        throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "FILE_NOT_FOUND", stringArray, null);
                    }
                    if (n == 5) {
                        stringArray = "Unable to mount DVD, already mounted.";
                        String string2 = HSCResourceBundleUtil.getMessage(CMD_LINE_BUNDLE, "DVD_ALREADY_MOUNTED", (String)stringArray, null);
                        throw new HSCException(string2);
                    }
                    if (n == 6) {
                        stringArray = "Unable to mount DVD.";
                        String string3 = HSCResourceBundleUtil.getMessage(CMD_LINE_BUNDLE, "UNABLE_TO_MOUNT_DVD", (String)stringArray, null);
                        throw new HSCException(string3);
                    }
                    if (n == 7) {
                        n = 0;
                        continue;
                    }
                    if (n == 0) continue;
                    throw new PIHscClientException("8016", CMD_LINE_BUNDLE, "COMMAND_LINE_ERROR", null, null);
                }
                break block17;
            }
            if (!this.writeToFTP) break block17;
            StringTokenizer stringTokenizer = new StringTokenizer(this.filenames, " ");
            while (stringTokenizer.hasMoreTokens() && n == 0) {
                Object object;
                StringBuffer stringBuffer = new StringBuffer(120);
                String string = stringTokenizer.nextToken();
                stringBuffer.append("/opt/hsc/bin/ftpDumpToServer ").append(string).append(' ');
                stringBuffer.append(this.hostname).append(' ').append(this.username).append(' ').append(this.password);
                if (this.directory != null) {
                    stringBuffer.append(' ').append(this.directory);
                }
                try {
                    object = Runtime.getRuntime().exec(stringBuffer.toString());
                    n = object.waitFor();
                }
                catch (Throwable throwable) {
                    throw new PIHscClientException("8016", CMD_LINE_BUNDLE, "COMMAND_LINE_ERROR", null, null);
                }
                if (n == 2) {
                    object = new String[]{string};
                    throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "FILE_NOT_FOUND", (String[])object, null);
                }
                if (n == 5) {
                    object = "An error occurred attempting to contact the remote system. Ensure a valid hostname or IP address has been entered and retry the command.";
                    String string4 = HSCResourceBundleUtil.getMessage(CMD_LINE_BUNDLE, "UNABLE_TO_CONNECT", (String)object, null);
                    throw new HSCException(string4);
                }
                if (n == 6 || n == 7 || n == 21 || n == 22) {
                    object = "Unable to log in to FTP server.";
                    String string5 = HSCResourceBundleUtil.getMessage(CMD_LINE_BUNDLE, "UNABLE_TO_LOGIN_TO_FTP", (String)object, null);
                    throw new HSCException(string5);
                }
                if (n == 8 || n == 9) {
                    object = "Unable to change to the target directory.";
                    String string6 = HSCResourceBundleUtil.getMessage(CMD_LINE_BUNDLE, "UNABLE_TO_CD", (String)object, null);
                    throw new HSCException(string6);
                }
                if (n == 24) {
                    object = "Unable to copy file, permission denied.";
                    String string7 = HSCResourceBundleUtil.getMessage(CMD_LINE_BUNDLE, "UNABLE_TO_COPY_PERMISSION", (String)object, null);
                    throw new HSCException(string7);
                }
                if (n == 0) continue;
                throw new PIHscClientException("8016", CMD_LINE_BUNDLE, "COMMAND_LINE_ERROR", null, null);
            }
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void mapParameters(HashMap hashMap, PrintStream printStream) throws PIHscClientException {
        this.writeToFTP = false;
        this.writeToDVD = false;
        String string = (String)hashMap.get("-r");
        this.hostname = (String)hashMap.get("-h");
        this.username = (String)hashMap.get("-u");
        this.password = (String)hashMap.get("--passwd");
        this.directory = (String)hashMap.get("-d");
        this.filenames = (String)hashMap.get("-f");
        if (string == null) {
            String[] stringArray = new String[]{"-r"};
            throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if ((string = string.trim()).equals(FTP_PARAM)) {
            this.writeToFTP = true;
        } else {
            if (!string.equals(DVD_PARAM)) {
                String[] stringArray = new String[]{"-r"};
                throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", stringArray, null);
            }
            this.writeToDVD = true;
        }
        if (this.filenames == null) {
            String[] stringArray = new String[]{"-f"};
            throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        this.filenames = this.filenames.trim();
        if (this.filenames.length() == 0) {
            String[] stringArray = new String[]{"-f"};
            throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", stringArray, null);
        }
        if (this.writeToDVD) {
            PIHMCCommandUtils.checkInvalidCombination(hashMap, FTP_PARAMS);
        }
        if (this.writeToFTP) {
            if (this.hostname == null) {
                String[] stringArray = new String[]{"-h"};
                throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "REQUIRED_PARMS_ERROR", stringArray, null);
            }
            this.hostname = this.hostname.trim();
            if (this.hostname.length() == 0) {
                String[] stringArray = new String[]{"-h"};
                throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", stringArray, null);
            }
            if (this.username == null) {
                String[] stringArray = new String[]{"-u"};
                throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "REQUIRED_PARMS_ERROR", stringArray, null);
            }
            this.username = this.username.trim();
            if (this.username.length() == 0) {
                String[] stringArray = new String[]{"-u"};
                throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", stringArray, null);
            }
            if (this.password != null) {
                this.password = this.password.trim();
                if (this.password.length() == 0) {
                    String[] stringArray = new String[]{"--passwd"};
                    throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", stringArray, null);
                }
            } else {
                this.readPassword(printStream);
            }
            if (this.directory != null) {
                this.directory = this.directory.trim();
                if (this.directory.length() == 0) {
                    String[] stringArray = new String[]{"-d"};
                    throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", stringArray, null);
                }
            }
        }
    }

    public void printResults(int n, PrintStream printStream) {
    }

    public static void printHelp(PrintStream printStream) {
        String string = "Usage: cpdump -r dvd | ftp -f <\"files\">\n              [-h <hostname>]\n              [-u <userid>]\n              [--passwd <password>]\n              [-d <directory>]\n              [--help]\n\ncopies dumps from the HMC to another storage location, either DVD or remote\nFTP site.\n\n    -r dvd | ftp           - the storage location where the dumps will be copied:\n                               dvd - DVD drive\n                               ftp - remote FTP site\n    -f <\"files\">           - The file name(s) of dump files to be copied.  If\n                             muliple files are to be copied, the file names must\n                             be separated by blanks and enclosed in double quotes.\n    -h <hostname>          - the hostname or IP Address of the remote server\n                             where the backup data will be written\n    -u <user name>         - the user name to use to log in to the FTP server\n    --passwd <password>    - the password to use to log in to the FTP server.\n                             If this parameter is omitted, then you will be\n                             prompted for the password.\n    -d <directory>         - the directory to use on the remote FTP site.\n    --help                 - prints this help";
        printStream.println(HSCResourceBundleUtil.getMessage(CMD_LINE_BUNDLE, "CPDUMP_HELP", string, null));
    }

    public static void main(String[] stringArray) {
        int n;
        String[] stringArray2;
        boolean bl = false;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String string = null;
        int n2 = 0;
        PIHscUtil.initHscUtil(3);
        PICpDump pICpDump = new PICpDump();
        try {
            stringArray2 = null;
            if (0 == stringArray.length) {
                PICpDump.printHelp(System.out);
                bl = true;
            }
            for (n = 0; n < stringArray.length; ++n) {
                stringArray2 = stringArray[n];
                arrayList.add(stringArray2);
                if (!stringArray2.equals("--help")) continue;
                PICpDump.printHelp(System.out);
                bl = true;
                break;
            }
            if (!bl) {
                HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pICpDump.m_validParms);
                pICpDump.mapParameters(hashMap, System.out);
                n2 = pICpDump.performCommand();
                pICpDump.printResults(n2, System.out);
            }
        }
        catch (PIHscClientException pIHscClientException) {
            if ("8000".equals(pIHscClientException.getHscExId())) {
                System.out.println(pIHscClientException.getMessage());
            } else {
                pIHscClientException.printStackTrace(System.out);
                string = pIHscClientException.getMessage();
                if (string == null) {
                    string = HSCResourceBundleUtil.getMessage(CMD_LINE_BUNDLE, "COMMAND_LINE_ERROR");
                }
                System.out.println(string);
            }
            n2 = 1;
        }
        catch (HSCException hSCException) {
            string = hSCException.getMessage();
            if (string == null) {
                string = HSCResourceBundleUtil.getMessage(CMD_LINE_BUNDLE, "COMMAND_LINE_ERROR");
            }
            System.out.println(string);
            n2 = 1;
        }
        try {
            stringArray2 = new String[]{"cpdump"};
            for (n = 0; n < stringArray.length; ++n) {
                stringArray2[0] = stringArray2[0] + " " + stringArray[n];
                if (!stringArray[n].equals("--passwd") || n >= stringArray.length - 1 || stringArray[n + 1].startsWith("-")) continue;
                stringArray2[0] = stringArray2[0] + " ********";
                ++n;
            }
            if (n2 == 0) {
                HSCLogUtils.logSystemEvent((short)2123, "", stringArray2, PIHscUtil.getOriginalUser());
            } else {
                HSCLogUtils.logSystemEvent((short)2124, "", stringArray2, PIHscUtil.getOriginalUser());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.exit(n2);
    }
}

